<?php
/**
 * Teste Imediato - Forçar Registro do velozpay
 */

// Verificar se estamos no WordPress
if (!defined('ABSPATH')) {
    echo "<h2>❌ Plugin não está sendo executado no WordPress</h2>";
    echo "<p>Este arquivo deve ser acessado através do WordPress.</p>";
    exit;
}

echo "<h1>🚀 Teste Imediato - velozpay</h1>";
echo "<hr>";

// Verificar se WooCommerce está ativo
if (!class_exists('WooCommerce')) {
    echo "<p>❌ WooCommerce não está ativo!</p>";
    exit;
}

echo "<p>✅ WooCommerce está ativo</p>";

// Verificar se a classe do gateway existe
if (!class_exists('WC_PIX_Gateway')) {
    echo "<p>❌ Classe WC_PIX_Gateway não encontrada!</p>";
    echo "<p>Verifique se o arquivo includes/class-wc-pix-gateway.php está sendo carregado.</p>";
    exit;
}

echo "<p>✅ Classe WC_PIX_Gateway encontrada</p>";

// Verificar se o gateway está registrado ANTES
echo "<h3>Status ANTES da correção:</h3>";
$gateways_before = apply_filters('woocommerce_payment_gateways', array());

echo "<p><strong>Gateways registrados:</strong></p>";
echo "<ul>";
foreach ($gateways_before as $gateway) {
    echo "<li>{$gateway}</li>";
}
echo "</ul>";

$pix_found_before = false;
foreach ($gateways_before as $gateway) {
    if ($gateway === 'WC_PIX_Gateway') {
        $pix_found_before = true;
        break;
    }
}

if ($pix_found_before) {
    echo "<p>✅ velozpay já estava registrado</p>";
} else {
    echo "<p>❌ velozpay NÃO estava registrado</p>";
}

// FORÇAR o registro do gateway
echo "<h3>🔧 Forçando registro do gateway...</h3>";

try {
    // Instanciar o gateway
    $pix_gateway = new WC_PIX_Gateway();
    echo "<p>✅ velozpay instanciado com sucesso</p>";
    
    // Verificar se foi registrado
    $gateways_after = apply_filters('woocommerce_payment_gateways', array());
    
    echo "<p><strong>Gateways registrados DEPOIS:</strong></p>";
    echo "<ul>";
    foreach ($gateways_after as $gateway) {
        echo "<li>{$gateway}</li>";
    }
    echo "</ul>";
    
    $pix_found_after = false;
    foreach ($gateways_after as $gateway) {
        if ($gateway === 'WC_PIX_Gateway') {
            $pix_found_after = true;
            break;
        }
    }
    
    if ($pix_found_after) {
        echo "<p>✅ velozpay foi registrado com sucesso!</p>";
    } else {
        echo "<p>❌ velozpay ainda não foi registrado</p>";
    }
    
} catch (Exception $e) {
    echo "<p>❌ Erro ao instanciar gateway: " . $e->getMessage() . "</p>";
}

// Verificar configurações do WooCommerce
echo "<h3>⚙️ Configurações do WooCommerce:</h3>";
$wc_settings = get_option('woocommerce_pix_gateway_settings', array());

if (!empty($wc_settings)) {
    echo "<p>✅ Configurações do gateway encontradas</p>";
    echo "<pre>" . print_r($wc_settings, true) . "</pre>";
} else {
    echo "<p>❌ Configurações do gateway NÃO encontradas</p>";
}

// Verificar se o gateway está habilitado
if (isset($wc_settings['enabled']) && $wc_settings['enabled'] === 'yes') {
    echo "<p>✅ Gateway está habilitado</p>";
} else {
    echo "<p>❌ Gateway NÃO está habilitado</p>";
}

// Verificar se há métodos de pagamento disponíveis
echo "<h3>💳 Métodos de Pagamento Disponíveis:</h3>";
if (function_exists('WC')) {
    $available_gateways = WC()->payment_gateways()->get_available_payment_gateways();
    
    if (!empty($available_gateways)) {
        echo "<p>✅ Métodos de pagamento disponíveis:</p>";
        echo "<ul>";
        foreach ($available_gateways as $gateway_id => $gateway) {
            echo "<li>{$gateway->get_title()} ({$gateway_id})</li>";
        }
        echo "</ul>";
    } else {
        echo "<p>❌ Nenhum método de pagamento disponível</p>";
    }
    
    // Verificar se o PIX está entre os disponíveis
    $pix_available = false;
    foreach ($available_gateways as $gateway_id => $gateway) {
        if ($gateway_id === 'pix_gateway') {
            $pix_available = true;
            break;
        }
    }
    
    if ($pix_available) {
        echo "<p>✅ velozpay está disponível no checkout</p>";
    } else {
        echo "<p>❌ velozpay NÃO está disponível no checkout</p>";
    }
} else {
    echo "<p>❌ WooCommerce não está funcionando corretamente</p>";
}

echo "<hr>";
echo "<h3>💡 Próximos Passos:</h3>";

if (!$pix_found_after) {
    echo "<p>1. <strong>REATIVE O PLUGIN</strong> em Plugins > Plugins Instalados</p>";
    echo "<p>2. Limpe o cache do site</p>";
    echo "<p>3. Teste novamente</p>";
} else {
    echo "<p>1. <strong>Configure o gateway</strong> em WooCommerce > Configurações > Pagamentos</p>";
    echo "<p>2. Habilite o gateway nas configurações</p>";
    echo "<p>3. Teste o checkout</p>";
}

echo "<hr>";
echo "<h3>🔗 Links Úteis:</h3>";
echo "<p><a href='" . admin_url('admin.php?page=wc-pix-gateway-settings') . "'>⚙️ Configurações do Plugin</a></p>";
echo "<p><a href='" . admin_url('admin.php?page=wc-settings&tab=checkout') . "'>💳 Configurações de Pagamento</a></p>";
echo "<p><a href='" . admin_url('plugins.php') . "'>📦 Gerenciar Plugins</a></p>";
echo "<p><a href='" . home_url('/checkout/') . "'>🛒 Ir para o Checkout</a></p>";

echo "<hr>";
echo "<p><em>Teste concluído em: " . date('d/m/Y H:i:s') . "</em></p>";
?>
